<?php 
    /**
    *
    * copyright (c) 2013-2021 Heliac Technologies
    * license http://opensource.org/licenses/gpl-license.php GNU GPL v3 
    *
    * linee guida per l'utilizzo del logo http://www.geecom.org/index.php?alias=linee-guida-per-luso-del-logo-geecom
    */

    class ArticoliDalBlog {
        private $db;
        private $id;
        private $nome;
        private $spazioOccupato; 
        private $numeroArticoli; 
        private $dimensioneDivSingoloArticolo;
        private $categoria;
        private $categorieIndicate; 
        private $escludiCategoria;
        private $lingua;
        private $etichettaPulsanteALtriArticoli;
        private $mostraTitoloComponente;
        private $mostraImmagini;
        private $mostraTesto;
        
        public function __construct($db, $id, $nome="", $spazioOccupato="", $numeroArticoli=0, $dimensioneDivSingoloArticolo="", $categoria=0, $categorieIndicate="", $escludiCategoria="", $lingua="", $etichettaPulsanteALtriArticoli="", $mostraTitoloComponente="", $mostraImmagini="", $mostraTesto="") {
            $this->db = $db;
            $this->id = $id;
            $this->nome = $nome;
            $this->spazioOccupato = $spazioOccupato;
            $this->numeroArticoli = $numeroArticoli;
            $this->dimensioneDivSingoloArticolo = $dimensioneDivSingoloArticolo;
            $this->categoria = $categoria;
            $this->categorieIndicate = $categorieIndicate;
            $this->escludiCategoria = $escludiCategoria;
            $this->lingua = $lingua;
            $this->etichettaPulsanteALtriArticoli = $etichettaPulsanteALtriArticoli;
            $this->mostraTitoloComponente = $mostraTitoloComponente;
            $this->mostraImmagini = $mostraImmagini;
            $this->mostraTesto = $mostraTesto;
        }

        function crea() {
            $query = "INSERT INTO geec_articoliDalBlog VALUES(NULL, '$this->nome', '$this->spazioOccupato','$this->numeroArticoli', '$this->dimensioneDivSingoloArticolo','$this->categoria', '$this->categorieIndicate', '$this->escludiCategoria', '$this->lingua', '$this->etichettaPulsanteALtriArticoli', '$this->mostraTitoloComponente','$this->mostraImmagini','$this->mostraTesto')";            
            $this->id = $this->db->eseguiQueryCreazione($query);
            return $this->id;
        }
        
        function modifica() {
            $query = "UPDATE geec_articoliDalBlog SET nome='$this->nome', spazioOccupato='$this->spazioOccupato', numeroArticoli=$this->numeroArticoli, dimensioneDivSingoloArticolo='$this->dimensioneDivSingoloArticolo', categoria='$this->categoria', categorieIndicate='$this->categorieIndicate', escludiCategoria='$this->escludiCategoria', lingua='$this->lingua', etichettaPulsanteAltriArticoli='$this->etichettaPulsanteALtriArticoli', mostraTitoloComponente='$this->mostraTitoloComponente', mostraImmagini='$this->mostraImmagini', mostraTesto='$this->mostraTesto' WHERE id=$this->id";
            $this->db->eseguiQueryScrittura($query);
        }
        
        function elimina() {
            $this->db->eseguiQueryCancellazione("geec_articoliDalBlog",$this->id);
            
            // elimina le occorrenze in cui la form è presente, l'id di questo componente è 40
            eliminaOccorrenzeComponente($this->db,$this->id,40);
        }
        
        function duplica() {
            $query    = "INSERT INTO geec_articoliDalBlog VALUES(NULL,'Copia di $this->nome')";
            $idNuovaForm = $this->db->eseguiQueryCreazione($query);
            
            $query       = "SELECT * FROM geec_elementiComponente WHERE idOccorenza='$this->id'";
            $risElementi = $this->db->eseguiQueryLettura($query);
            while($elementoDaCopiare = $risElementi->fetch_assoc()) {
                $query = "INSERT INTO `geec_elementiComponente` (`id`, `idOccorenza`, `posizione`, `nome`, `etichetta`, `valore`, `placeholder`, `tipo`, `opzioni`, `obbligatorio`) "
                    . "VALUES (NULL, '$idNuovaForm', '{$elementoDaCopiare["posizione"]}', '{$elementoDaCopiare["nome"]}', '{$elementoDaCopiare["etichetta"]}', '{$elementoDaCopiare["valore"]}', '{$elementoDaCopiare["placeholder"]}', '{$elementoDaCopiare["tipo"]}', '{$elementoDaCopiare["opzioni"]}', '{$elementoDaCopiare["obbligatorio"]}')";
                $this->db->eseguiQueryCreazione($query);
            }
            return $idNuovaForm;
        }
        
        function caricaDatiDalDatabase() {
            $datiArticoliDalBlog = $this->db->leggiSingolaRiga("geec_articoliDalBlog",$this->id);
            $this->nome                           = $datiArticoliDalBlog["nome"];
            $this->spazioOccupato                 = $datiArticoliDalBlog["spazioOccupato"];;
            $this->numeroArticoli                 = $datiArticoliDalBlog["numeroArticoli"];
            $this->dimensioneDivSingoloArticolo   = $datiArticoliDalBlog["dimensioneDivSingoloArticolo"];
            $this->categoria                      = $datiArticoliDalBlog["categoria"];
            $this->categorieIndicate              = $datiArticoliDalBlog["categorieIndicate"];
            $this->escludiCategoria               = $datiArticoliDalBlog["escludiCategoria"];
            $this->lingua                         = $datiArticoliDalBlog["lingua"];
            $this->etichettaPulsanteALtriArticoli = $datiArticoliDalBlog["etichettaPulsanteALtriArticoli"];
            $this->mostraTitoloComponente         = $datiArticoliDalBlog["mostraTitoloComponente"];
            $this->mostraImmagini                 = $datiArticoliDalBlog["mostraImmagini"];
            $this->mostraTesto                    = $datiArticoliDalBlog["mostraTesto"];
        }
        
        // getter & setter
        public function getDb() {
            return $this->db;
        }

        public function getId() {
            return $this->id;
        }

        public function getNome() {
            return $this->nome;
        }

        public function getSpazioOccupato() {
            return $this->spazioOccupato;
        }

        public function getNumeroArticoli() {
            return $this->numeroArticoli;
        }

        public function getDimensioneDivSingoloArticolo() {
            return $this->dimensioneDivSingoloArticolo;
        }

        public function getCategoria() {
            return $this->categoria;
        }

        public function getCategorieIndicate() {
            return $this->categorieIndicate;
        }

        public function getEscludiCategoria() {
            return $this->escludiCategoria;
        }

        public function getLingua() {
            return $this->lingua;
        }

        public function getEtichettaPulsanteALtriArticoli() {
            return $this->etichettaPulsanteALtriArticoli;
        }

        public function getMostraTitoloComponente() {
            return $this->mostraTitoloComponente;
        }

        public function getMostraImmagini() {
            return $this->mostraImmagini;
        }

        public function getMostraTesto() {
            return $this->mostraTesto;
        }

        public function setDb($db) {
            $this->db = $db;
        }

        public function setId($id) {
            $this->id = $id;
        }

        public function setNome($nome) {
            $this->nome = $nome;
        }

        public function setSpazioOccupato($spazioOccupato) {
            $this->spazioOccupato = $spazioOccupato;
        }

        public function setNumeroArticoli($numeroArticoli) {
            $this->numeroArticoli = $numeroArticoli;
        }

        public function setDimensioneDivSingoloArticolo($dimensioneDivSingoloArticolo) {
            $this->dimensioneDivSingoloArticolo = $dimensioneDivSingoloArticolo;
        }

        public function setCategoria($categoria) {
            $this->categoria = $categoria;
        }

        public function setCategorieIndicate($categorieIndicate) {
            $this->categorieIndicate = $categorieIndicate;
        }

        public function setEscludiCategoria($escludiCategoria) {
            $this->escludiCategoria = $escludiCategoria;
        }

        public function setLingua($lingua) {
            $this->lingua = $lingua;
        }

        public function setEtichettaPulsanteALtriArticoli($etichettaPulsanteALtriArticoli) {
            $this->etichettaPulsanteALtriArticoli = $etichettaPulsanteALtriArticoli;
        }

        public function setMostraTitoloComponente($mostraTitoloComponente) {
            $this->mostraTitoloComponente = $mostraTitoloComponente;
        }

        public function setMostraImmagini($mostraImmagini) {
            $this->mostraImmagini = $mostraImmagini;
        }

        public function setMostraTesto($mostraTesto) {
            $this->mostraTesto = $mostraTesto;
        }
        
    }